/*
Distanzstück für Rückwand des 7"-Raspberry-Pi-Displays,
das 2022 als "RPI All-In-One" von Like Sun GmbH aus Essen
geliefert wurde, später bis Mitte 2023 als
"EVICIV Touchscreen Monitor, 7 Zoll Raspberry Pi Display mit
Gehäuse Rahmen und Lüfter, 1024x600 HDMI Display",
momentan (Aug. 2023) unter dem Herstellernamen UPERFECT.

Als Hersteller ist auf der Verpackung angegeben:
Shenzen Dusun Technologiy Co., Ltd.

Ein vergleichbares 10"-Display war
https://www.amazon.de/dp/B0987RKJ6K
Das sieht hinten sehr ähnlich aus, aber ob der Rahmen dafür
auch paßt, ist nicht getestet.

150mm x 94mm
Radius Ecken 7mm
*/

ver="1.2";

/* Zuerst Maße und Positionen in Variablen sammeln. (Das ist
   aber inkonsequent gemacht, unten bei den Objekten stehen auch
   einige Werte. Mit diesen hier habe ich anfangs viel
   herumprobiert.) Am wichtigsten ist, daß alle relevanten Maße
   auf za bezogen sind, die Höhe kann also ohne weiteres verändert
   werden.
*/

xa=151; // x Breite
ya=95;  // y (je 1 mehr als die gemessenen Werte ist höher als die Schrumpfrate
        // von PLA, hat sich bei mir aber als sinnvoll erwiesen)
za=13;  // Höhe, kann für Testdrucke auf 6 verkleinert werden, größere
        // Werte sind möglich.
        // Bei za=13 passen handelsübliche Senkkopfschrauben M3x18.
ra=7;   // Radius Eckzylinder außen

// Abstände Achsen - Mitte der äußeren Eckzylinder:
cyloffsax=xa/2-ra;
cyloffsay=ya/2-ra;
//echo(cyloffsax);
thickn=5; // Abstand äußerer und innerer Eckzylinder (zusammen mit der
          // Differenz der Radien ra-ri ergibt das die Wandstärke)

 // innerer Eckzylinder (auszuschneidender Hohlraum)
cyloffsix=cyloffsax-thickn;
cyloffsiy=cyloffsay-thickn;
ri=4.5; // Radius Eckzylinder innen

// Randprofil oben
cyloffsix2=cyloffsax; // innere Eckzylinder (Profil)
cyloffsiy2=cyloffsay; // nur der Radius kleiner
or=1.5; // verbleibender Rand
ri2=ra-or; // Radiusdifferenz ist Breite des Randes
prh=2; // Höhe des ausgestanzten Profils

// Aussparung unten links (Kante bei Stromversorgung, HDMI, Audio)
a1x=1.7; a1y=41; a1z=1.5; // Abmessungen ohne aufgesetztes Dreieck
a1pxoff=0.9; // Abstand vom Rand
a1px=xa/2-a1x-a1pxoff; a1py=-a1y/2;  a1pz=-0.1; // Position
// (a1pz um 0.1 nach unten, weil sonst "not a valid 2-manifold" gewarnt wird)
// Aussparung unten rechts (Kante bei Ethernet, USB)
a2y=21;
a2py=-a2y/2;

// Aussparung Standfuß
a3x=52.4/2; a3y=10; a3x2=a3x-2.5; a3z=4.5;
a3pz=za-a3z;
// äußerer Steg an Standfußaussparung
a5x=a3x*2.1; a5z=1;
// Bereich um das Loch der mittleren Schraube
a6x=8.3; a6z=a5z;
// kleine tiefe Aussparung Standfuß
a4x=6.3; a4y=2.2; a4z=7;
a4px=9; a4py=-(ya/2-3+a4y/2); a4pz=za-a4z-a3z;

// Text
tz=0.75; // Höhe (z)

/* es folgen die Objekte */

difference() {

    difference() {
        // Rahmen außen
        hull() {
            translate([ cyloffsax, cyloffsay,0]) cylinder(h=za,r=ra);
            translate([-cyloffsax,-cyloffsay,0]) cylinder(h=za,r=ra);
            translate([ cyloffsax,-cyloffsay,0]) cylinder(h=za,r=ra);
            translate([-cyloffsax, cyloffsay,0]) cylinder(h=za,r=ra);
        }
        // Rahmen innen
        hull() {
            translate([ cyloffsix, cyloffsiy,0]) cylinder(h=za,r=ri);
            translate([-cyloffsix,-cyloffsiy,0]) cylinder(h=za,r=ri);
            translate([ cyloffsix,-cyloffsiy,0]) cylinder(h=za,r=ri);
            translate([-cyloffsix, cyloffsiy,0]) cylinder(h=za,r=ri);
        }

    }
    // Randprofil
    hull() {
        translate([ cyloffsix2, cyloffsiy2,za-prh]) cylinder(h=prh,r=ri2);
        translate([-cyloffsix2,-cyloffsiy2,za-prh]) cylinder(h=prh,r=ri2);
        translate([ cyloffsix2,-cyloffsiy2,za-prh]) cylinder(h=prh,r=ri2);
        translate([-cyloffsix2, cyloffsiy2,za-prh]) cylinder(h=prh,r=ri2);
    }

    // Aussparung unten links (Stromversorgung)
    translate([a1px+a1x/2,-a1py,a1pz])
        rotate(a=[90,0,0])
            linear_extrude(height = a1y, convexity = 10, twist = 0)
                polygon(points=[[-a1x/2,0],[a1x/2,0],[a1x/2,a1z],[0,a1z+a1x],[-a1x/2,a1z]], paths=[[0,1,2,3,4]]);

    // Aussparung unten rechts (USB)
    translate([-a1px-a1x/2, -a2py, a1pz])
        rotate(a=[90,0,0])
            linear_extrude(height = a2y, convexity = 10, twist = 0)
                polygon(points=[[-a1x/2,0],[a1x/2,0],[a1x/2,a1z],[0,a1z+a1x],[-a1x/2,a1z]], paths=[[0,1,2,3,4]]);

   
    // Bohrlöcher
    translate([           0, (ya/2-4),0]) cylinder(h=za,r=1.7, $fn=25);
    translate([           0,-(ya/2-4),0]) cylinder(h=za,r=1.7, $fn=25);
    translate([ (xa/2-16.5), (ya/2-4),0]) cylinder(h=za,r=1.7, $fn=25);
    translate([-(xa/2-16.5),-(ya/2-4),0]) cylinder(h=za,r=1.7, $fn=25);
    translate([-(xa/2-16.5), (ya/2-4),0]) cylinder(h=za,r=1.7, $fn=25);
    translate([ (xa/2-16.5),-(ya/2-4),0]) cylinder(h=za,r=1.7, $fn=25);

    // Führungslöcher für separat zu druckenden vorderen Aufsatz
    translate([ (-20),-(ya/2-4),0])
        union() {
            cylinder(h=3,r=1.2, $fn=25);
            cylinder(h=0.5,r1=1.6,r2=1.2, $fn=25); // Senkung
        }
    translate([ ( 20),-(ya/2-4),0])
        union() {
            cylinder(h=3,r=1.2, $fn=25);
            cylinder(h=0.5,r1=1.6,r2=1.2, $fn=25);
        }

    // Aussparung für vergossene Rückwandmuttern
    translate([ (-37.5), (ya/2-10),za-or-4]) cylinder(h=4,r=4, $fn=25);
    translate([ ( 37.5), (ya/2-10),za-or-4]) cylinder(h=4,r=4, $fn=25);
    translate([ (-37.5),-(ya/2-10),za-or-4]) cylinder(h=4,r=4, $fn=25);
    translate([ ( 37.5),-(ya/2-10),za-or-4]) cylinder(h=4,r=4, $fn=25);


    difference() {
        // Aussparung Standfuß
        translate([           0, -(ya/2), a3pz])
        linear_extrude(height = a3z, convexity = 10, twist = 0)
                        polygon(points=[[-a3x,0],[a3x,0],[a3x2,a3y],[-a3x2,a3y]], paths=[[0,1,2,3]]);

        // äußerer Steg an Standfußaussparung
         translate([-a5x/2, -ya/2  , a3pz])
        cube(size = [a5x, or, a5z], center = false);

        // Bereich um das Loch der mittleren Schraube
        translate([-a6x/2, -ya/2+or  , a3pz])
        cube(size = [a6x, thickn+ra-ri, a6z], center = false);
    }

    // kleine tiefe Aussparung Standfuß (Nase an der Rückwand)
    translate([a4px, a4py, a4pz])
        cube(size = [a4x,a4y,a4z], center = false);

    // Versionstext
    translate([ xa/6, ya/2-4.4, za-prh-tz])
        rotate(a=[0,0,0])
            linear_extrude( height = tz )
                text(
                    text = ver, 
                    size = 3.9, 
                    font = "Liberation Sans:style=Bold", 
                    valign = "center", 
                    halign = "center",
                    $fn = 50
                );
}


aax=51;
aay=7.5;
aaz=3.5;
difference() {
    cube(size = [aax, aay, aaz], center = false);
    translate([ aax/2, aay/2, 0]) cylinder(h=aaz,r=1.7, $fn=25);
}

// es folgt der separate Aufsatz:
// Führungsstifte
pinH=1.7;
pinR=1.0;
phaseH=0.5;
phaseR=0.7;
hull() {
    translate([ aax/2-20, aay/2, 0]) cylinder(h=aaz+pinH,r=pinR, $fn=20);
    translate([ aax/2-20, aay/2, 0]) cylinder(h=aaz+pinH+phaseH,r=phaseR, $fn=20);
}

hull() {
    translate([ aax/2+20, aay/2, 0]) cylinder(h=aaz+pinH,r=pinR, $fn=20);
    translate([ aax/2+20, aay/2, 0]) cylinder(h=aaz+pinH+phaseH,r=phaseR, $fn=20);
}

